// ===== ANIMATION INTRO TV VINTAGE MODIFIÉE =====
function initTVIntro() {
    // Créer l'overlay d'intro simplifié
    const introHTML = `
        <div class="tv-intro-overlay" id="tvIntro">
            <div class="tv-screen">
                <div class="tv-line"></div>
                <div class="tv-flash"></div>
                <div class="tv-static"></div>
                <div class="tv-glow"></div>
                <div class="tv-scanlines"></div>
                <div class="tv-vignette"></div>
                <div class="tv-afterglow"></div>
                <div class="tv-loading">
                    <div class="tv-loading-title">
                        <div class="tv-loading-main">DATAVISUALISATION</div>
                    </div>
                    <div class="tv-loading-bar">
                        <div class="tv-loading-progress"></div>
                    </div>
                    <div class="tv-loading-text">
                        <span class="tv-loading-pulse">CHARGEMENT</span>
                        <span class="tv-loading-dots">...</span>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    document.body.insertAdjacentHTML('afterbegin', introHTML);
    
    // Masquer l'intro après 3.5 secondes
    setTimeout(() => {
        const intro = document.getElementById('tvIntro');
        if(intro) {
            intro.classList.add('fade-out');
            setTimeout(() => {
                intro.classList.add('hidden');
                intro.remove();
            }, 800);
        }
    }, 3500);
}
// La navigation est maintenant gérée dans main-chart.js

// ===== ANIMATIONS AU SURVOL =====
function initHoverAnimations() {
    // Animation des stats
    const statItems = document.querySelectorAll('.stat-item');
    statItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.05) translateY(-5px)';
            this.style.boxShadow = '0 10px 30px rgba(255, 107, 139, 0.3)';
        });
        
        item.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1) translateY(0)';
            this.style.boxShadow = '';
        });
    });
    
    // Animation des légendes de graphiques
    const legendItems = document.querySelectorAll('.legend-item');
    legendItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.1)';
            this.style.fontWeight = '700';
        });
        
        item.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
            this.style.fontWeight = '';
        });
    });
    
    // Animation des infos sous les graphiques
    const chartFooters = document.querySelectorAll('.chart-footer');
    chartFooters.forEach(footer => {
        footer.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.02)';
            this.style.background = 'rgba(255, 255, 255, 0.08)';
        });
        
        footer.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
            this.style.background = '';
        });
    });
}

// ===== CALCULS MATHÉMATIQUES =====
function calculateStatistics(data) {
    if (!data || data.length === 0) return null;
    
    // Moyenne
    const mean = data.reduce((sum, val) => sum + val, 0) / data.length;
    
    // Variance
    const variance = data.reduce((sum, val) => sum + Math.pow(val - mean, 2), 0) / data.length;
    
    // Écart-type
    const stdDev = Math.sqrt(variance);
    
    // Médiane
    const sorted = [...data].sort((a, b) => a - b);
    const median = sorted.length % 2 === 0
        ? (sorted[sorted.length / 2 - 1] + sorted[sorted.length / 2]) / 2
        : sorted[Math.floor(sorted.length / 2)];
    
    // Écart à la parité (50%)
    const parityGap = Math.abs(50 - mean);
    
    return {
        mean: mean.toFixed(2),
        variance: variance.toFixed(2),
        stdDev: stdDev.toFixed(2),
        median: median.toFixed(2),
        parityGap: parityGap.toFixed(2)
    };
}

function calculateCorrelation(dataTV, dataRadio) {
    if (!dataTV || !dataRadio || dataTV.length !== dataRadio.length) return null;
    
    const n = dataTV.length;
    const meanTV = dataTV.reduce((sum, val) => sum + val, 0) / n;
    const meanRadio = dataRadio.reduce((sum, val) => sum + val, 0) / n;
    
    let numerator = 0;
    let denomTV = 0;
    let denomRadio = 0;
    
    for (let i = 0; i < n; i++) {
        const diffTV = dataTV[i] - meanTV;
        const diffRadio = dataRadio[i] - meanRadio;
        numerator += diffTV * diffRadio;
        denomTV += diffTV * diffTV;
        denomRadio += diffRadio * diffRadio;
    }
    
    const correlation = numerator / Math.sqrt(denomTV * denomRadio);
    return correlation.toFixed(3);
}

function updateMathematicalStats(year) {
    const yearsData = window.CSV_DATA?.years;
    if (!yearsData) return;
    
    const tvData = yearsData.tv?.[year];
    const radioData = yearsData.radio?.[year];
    
    if (!tvData && !radioData) return;
    
    // Collecter toutes les valeurs
    const allValues = [];
    const tvValues = [];
    const radioValues = [];
    
    if (tvData) {
        Object.values(tvData).forEach(value => {
            if (typeof value === 'number') {
                allValues.push(value);
                tvValues.push(value);
            }
        });
    }
    
    if (radioData) {
        Object.values(radioData).forEach(value => {
            if (typeof value === 'number') {
                allValues.push(value);
                radioValues.push(value);
            }
        });
    }
    
    if (allValues.length > 0) {
        const stats = calculateStatistics(allValues);
        
        // Mettre à jour l'affichage
        const varianceEl = document.getElementById('variance');
        const stdDevEl = document.getElementById('stdDev');
        const medianEl = document.getElementById('median');
        const parityGapEl = document.getElementById('parityGap');
        const correlationEl = document.getElementById('correlation');
        
        if (varianceEl) varianceEl.textContent = stats.variance;
        if (stdDevEl) stdDevEl.textContent = stats.stdDev;
        if (medianEl) medianEl.textContent = stats.median + '%';
        if (parityGapEl) parityGapEl.textContent = stats.parityGap + '%';
        
        // Calculer la corrélation TV/Radio
        if (tvValues.length > 0 && radioValues.length > 0) {
            const minLength = Math.min(tvValues.length, radioValues.length);
            const correlation = calculateCorrelation(
                tvValues.slice(0, minLength),
                radioValues.slice(0, minLength)
            );
            if (correlationEl) correlationEl.textContent = correlation;
        }
    }
}

// ===== BASCULEMENT ENTRE MODES =====
function toggleMode() {
    const dashboard = document.getElementById('dashboard');
    const artisticMode = document.getElementById('artisticMode');
    const labSwitch = document.getElementById('lab-switch');
    
    console.log('toggleMode appelé');
    console.log('Dashboard:', dashboard);
    console.log('ArtisticMode:', artisticMode);
    console.log('Switch checked:', labSwitch?.checked);
    
    if (!dashboard || !artisticMode) {
        console.error('Éléments dashboard ou artisticMode non trouvés');
        return;
    }
    
    if (labSwitch && labSwitch.checked) {
        // Passer en mode artistique
        console.log('Passage en mode artistique');
        dashboard.style.display = 'none';
        artisticMode.style.display = 'block';
        artisticMode.classList.add('fade-in');
        
        // Initialiser D3 si pas déjà fait
        setTimeout(() => {
            if (typeof initArtisticD3 === 'function') {
                console.log('Initialisation D3...');
                initArtisticD3();
            } else {
                console.error('initArtisticD3 non disponible');
            }
        }, 100);
    } else {
        // Retour au mode scientifique
        console.log('Retour au mode scientifique');
        artisticMode.style.display = 'none';
        dashboard.style.display = 'block';
    }
}

// Initialiser au chargement
document.addEventListener('DOMContentLoaded', function() {
    // Lancer l'intro TV
    initTVIntro();
    
    // Attendre la fin de l'intro pour initialiser les interactions
    setTimeout(() => {
        initHoverAnimations();
        
        // Gérer le basculement de mode
        const labSwitch = document.getElementById('lab-switch');
        if (labSwitch) {
            labSwitch.addEventListener('change', toggleMode);
            console.log('Switch mode artistique/scientifique initialisé');
        } else {
            console.error('Switch lab-switch non trouvé');
        }
        
        // Gérer les contrôles du mode artistique
        const artisticYearSelect = document.getElementById('artisticYearSelect');
        if (artisticYearSelect) {
            artisticYearSelect.addEventListener('change', (e) => {
                if (typeof updateArtisticYear === 'function') {
                    updateArtisticYear(e.target.value);
                }
            });
        }
        
        const refreshArtisticBtn = document.getElementById('refreshArtisticBtn');
        if (refreshArtisticBtn) {
            refreshArtisticBtn.addEventListener('click', () => {
                if (typeof refreshArtisticD3 === 'function') {
                    refreshArtisticD3();
                }
            });
        }
    }, 4000);
});


